#ifndef TRELLIS_H
#define TRELLIS_H

#include "sequence.h"

SEQ map_decoder( SEQ seq, const base initBase, const bool basespace, const double * probs);

double * construct_trellis_probs(SEQ seq, const bool ecc);
double * forwards_trellis ( const double * trell_probs, const base initB, const size_t seqlen, const size_t kmerlen);
double * backwards_trellis ( const double * trell_probs, const base initB, const size_t seqlen, const size_t kmerlen);
double * check_likelihoods(const double * fwd, const double * bwd, const double * trell_probs, const size_t seqlen, const size_t nkmer);

SEQ viterbi_decoder(SEQ seq, const base initB, const bool basespace, const double * probs);
double * viterbi_trellis(const double * trell_probs, const base initB, const size_t seqlen, const size_t kmerlen);

double sequence_likelihood(const SEQ seq, const base initB, const double * probs);

#endif /* TRELLIS_H */
