#ifndef QUAL_H
#define QUAL_H

#include <stdio.h>

/** Quality values
 *  Four scales used: 
 *    PhredC: Phred characters
 *    Prob:   Probabilities, p 
 *    PhredQ: Phred quality scale -10 log_10 (1-p)
 *    Qual:   Log-scale probabilities, log(p)
 */

typedef float qual;
typedef float prob;
typedef float phredq;
typedef unsigned char phredc;

#define QUALITY_PHREDC_MIN 	 33
#define QUALITY_PHREDC_MAX 	126
#define QUALITY_PHREDC_MISSING 	 33

/* From phredc */
prob phredc2prob(const phredc c);
qual phredc2qual(const phredc c);
/* From phredq */
prob phredq2prob(const phredq q);
phredc phredq2phredc(const phredq q);
qual phredq2qual(const phredq q);
/* From qualities */
phredq qual2phredq(const qual q);
phredc qual2phredc(const qual q);
prob qual2prob(const qual q);


void fprint_qual(FILE * fp, const qual q);
#endif /* QUAL_H */

