#include <stdlib.h>
#include "gf4.h"
#include "probe_inc.h"

base probe1_color[NKMER];
base probe2_color[NKMER];

base color_of_probe(int kmer, const base probeGen[MAXCODE]){
	base r = baseA;
	for ( int i=0 ; i<MAXCODE ; i++){
		base b = kmer&3;
		r = gf4_add(r,gf4_mult(probeGen[MAXCODE-i-1],b));
		kmer>>=2;
	}
	return r;
}


base origGen[MAXCODE] = { baseC,baseC };
void init_probes(const base probeGen[MAXCODE]){
   for( int i=0 ; i<NKMER ; i++){
      probe1_color[i] = color_of_probe(i,origGen);
      probe2_color[i] = color_of_probe(i,probeGen);
   }
}
