#include "base.h"
#include <err.h>
#include <stdlib.h>

static char baseChars[] = {'A','C','G','T','N'};
static char colorChars[] = {'0','1','2','3','.'};

char base2char(const base b){
	return baseChars[b];
}

char base2colorchar(const base b){
	return colorChars[b];
}

base char2base(const char c){
	switch(c){
		case '0': case 'a': case 'A': return baseA; break;
		case '1': case 'c': case 'C': return baseC; break;
		case '2': case 'g': case 'G': return baseG; break;
		case '3': case 't': case 'T': return baseT; break;
		case '.': case 'n': case 'N': return baseN; break;
	}

	errx(EXIT_FAILURE,"Unrecognised nucleotide in %s (%s:%d)",__func__,__FILE__,__LINE__);
	return -1;
}

void fprint_base(FILE * fp,const base b){
	fputc(base2char(b),fp);
}

void fprint_color(FILE * fp,const base b){
	fputc(base2colorchar(b),fp);
}


void fprint_block(FILE * fp, const base * bl){
	fprint_baseVec(fp,bl,BLOCK_SIZE);
}

void fprint_baseVec(FILE * fp, const base * bl, const int size){
	if(NULL==fp){ return; }
	if(NULL==bl){ return; }
	for ( int i=0 ; i<size ; i++){
		fprint_base(fp,bl[i]);
	}
}
