#ifndef SEQUENCE_H
#define SEQUENCE_H

#include "base.h"
#include "qual.h"
#include <stdbool.h>

typedef struct {
	char * name;			// Name + other info (Fasta header). One line, free text
	unsigned int len;		// length of sequence
	base initBase;
	base * base, *ebase;			// Array of bases
	qual * qual, *equal;			// Qualities, log-scaled.
} * SEQ;

SEQ new_SEQ(const unsigned int len, const bool hasQual, const bool hasECC);
void free_SEQ(SEQ seq);
SEQ copy_SEQ(const SEQ seq);
void fprint_SEQ(FILE * fp,SEQ seq, const bool showQual, const bool baseSpace);
void fprint_timSEQ(FILE * fp, const SEQ seq, const SEQ trueSeq);
SEQ read_seq(FILE * fp);
SEQ read_fasta(FILE * fp);

bool has_qualities(SEQ seq);
bool has_ecc(SEQ seq);


#endif /* SEQUENCE_H */
