#include "qual.h"
#include <math.h>
#include <stdlib.h>

prob phredc2prob(const phredc c){
	return -expm1f(- M_LN10 * (c-33)/10.f);
}

qual phredc2qual(const phredc c){
	return logf(phredc2prob(c));
}

prob phredq2prob(const phredq q){
	return -expm1f(- M_LN10 * q/10.f);
}
phredc phredq2phredc(const phredq q){
	phredc c = 33 + roundf(q);
	if(c<=QUALITY_PHREDC_MIN){abort();}
	if(c<QUALITY_PHREDC_MIN){ c = QUALITY_PHREDC_MIN;}
	if(c>QUALITY_PHREDC_MAX){ c = QUALITY_PHREDC_MAX;}
	return c;
}

qual phredq2qual(const phredq q){
	return logf(phredq2prob(q));
}

phredq qual2phredq(const qual q){
	return -10.f*logf(-expm1f(q))*M_LOG10E;
}

phredc qual2phredc(const qual q){
	return phredq2phredc(qual2phredq(q));
}

prob qual2prob(const qual q){
	return exp(q);
}

prob qual2_1mprob(const qual q){
	return -expm1(q);
}

void fprint_qual(FILE * fp, const qual q){
	if(NULL==fp){return;}
	fputc(qual2phredc(q),fp);
}

