#include <stdlib.h>
#include "conversion.h"
#include "gf4.h"

base convert_to_ecc ( const base * b,const base probeGen[MAXCODE]){
	if(NULL==b){ return baseN; }
	base r = baseA;
	for ( int i=0 ; i<MAXCODE ; i++){
		r = gf4_add(r,gf4_mult(b[i],probeGen[i]));
	}
	return r;
}

base * convert_sequence_to_ecc( const base * b, const int len, const base probeGen[MAXCODE]){
	if(NULL==b){ return NULL; }
	base * ecc = calloc(len,sizeof(base));
	if(NULL==ecc){ return NULL; }

	for( int i=0 ; i<len ; i++){
		ecc[i] = baseN; 
	}

	for ( int i=1 ; i<len ; i+=5){
		ecc[i+1] = gf4_add(baseT,convert_to_ecc(b+i,probeGen));
	}
	return ecc;
}

base convert_to_color ( const base * b){
	if(NULL==b){ return baseN; }
	return gf4_add(b[0],b[1]);
}

base * convert_sequence_to_color( const base * b, const base initB, const int len){
	if(NULL==b){ return NULL; }
	base * col = calloc(len,sizeof(base));
	if(NULL==col){ return NULL;}

	col[0] = gf4_add(initB,b[0]);
	for(int i=1 ; i<len ; i++){
		col[i] = gf4_add(b[i-1],b[i]);
	}

	return col;
}

void convert_sequence_to_color_inplace(  base * b, const base initB, const int len){
	if(NULL==b){ return; }
	base prev = gf4_add(initB,b[0]);
	for(int i=1 ; i<len ; i++){
		base curr = gf4_add(b[i-1],b[i]);
		b[i-1] = prev;
		prev = curr;
	}
	b[len-1] = prev;
	return;
}
