#!/bin/bash

declare -a nms
nms=( "MAGIC_2hrGlucose_AdjustedForBMI.txt" "MAGIC_ln_HOMA-B.txt" "MPV.b37" "TC_ONE_Europeans.tbl" "MAGIC_FastingGlucose.txt" "MAGIC_ln_HOMA-IR.txt" "TG_ONE_Europeans.tbl" "HDL_ONE_Europeans.tbl" "MAGIC_HbA1C.txt" "MCH.b37" "PCV.b37" "HGB.b37" "MAGIC_ln_FastingInsulin.txt" "MCHC.b37" "PLT.b37" "LDL_ONE_Europeans.tbl" "MAGIC_ln_fastingProinsulin.txt" "MCV.b37" "RBC.b37" "GIANT_HEIGHT_LangoAllen2010_publicrelease_HapMapCeuFreq.txt" "GIANT_WHRadjBMI_Heid2010_publicrelease_HapMapCeuFreq.txt" "GIANT_BMI_Speliotes2010_publicrelease_HapMapCeuFreq.txt"  "DIAGRAMv3.2012DEC17.txt" "ICBP_DBP_gwas" "ICBP_SBP_gwas" "SCZ" "EUR.CD.gwas_info03_filtered.assoc" "EUR.UC.gwas_info03_filtered.assoc" "EUR.IBD.gwas_info03_filtered.assoc" )

INPUTNAME=${nms[$[${LSB_JOBINDEX}-1]]}

DATADIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/garfield-data0
PVALDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/input/$INPUTNAME
if [[ ${LSB_JOBINDEX} -gt 23 ]];then
if [[ ${LSB_JOBINDEX} -lt 26 ]];then 
PVALDIR=$DATADIR/pval/$INPUTNAME
fi
fi

PRUNETAGSDIR=$DATADIR/tags/r001
CLUMPTAGSDIR=$DATADIR/tags/r08
MAFTSSDDIR=$DATADIR/features_r001
ANNOTDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/FDR/bedfiles/annotations
OUTDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/$INPUTNAME
mkdir -p $OUTDIR

ANNOTLINKFILE=$ANNOTDIR/link_file.txt
NANNOT=$((`cat $ANNOTLINKFILE | wc -l` - 1))
F1=$OUTDIR/garfield.prep.$INPUTNAME.random.noLDpruning.noLDclumping.out

echo -n > $F1.tmp
for CHR in `seq 1 22`
do
awk 'NR==FNR {a[$1]=$1; b[$1]=$2; next;} $1 in a {print b[$1],$2}' $PVALDIR/chr$CHR $ANNOTDIR/chr$CHR >> $F1.tmp
echo $CHR
done
paste -d" " <(awk '{print $1}' $F1.tmp) <(awk '{print $2}' $F1.tmp | sed 's/1/1 /g' | sed 's/0/0 /g') > $F1.tmp2
mv $F1.tmp2 $F1.tmp


for i in {1000..1}
do

SUBSET="0"
CONDITION=0
BINNING="m1,n1,t1,p1,k1"
PTHRESH=1e-8

F3=$OUTDIR/garfield.perm.$INPUTNAME.null.annotations.cap.R.feat.$BINNING.$PTHRESH.random.noLDpruning.noLDclumping.out.$i

bsub -M 12000 -R'rusage[mem=12000] select[mem>12000]' -o logsKBSPAN/log.perm.naive.random.$INPUTNAME.$i -- ./naive_run_sub_null.sh $F1 $i $F3 $ANNOTLINKFILE $PTHRESH $BINNING $SUBSET $CONDITION

done

# bsub -q yesterday -M 1000 -R'rusage[mem=1000] select[mem>1000]' -J"perm2[1-29]" -o logsKBSPAN/log.perm.naive.random.%I  -- ./naive_run_null.sh
