#!/bin/bash

j=${LSB_JOBINDEX}

declare -a traits
traits=( "MPV.b37" "TC_ONE_Europeans.tbl" "MAGIC_FastingGlucose.txt" "TG_ONE_Europeans.tbl" "HDL_ONE_Europeans.tbl" "MAGIC_HbA1C.txt" "MCH.b37" "PCV.b37" "HGB.b37" "MCHC.b37" "PLT.b37" "LDL_ONE_Europeans.tbl" "MAGIC_ln_fastingProinsulin.txt" "MCV.b37" "RBC.b37" "GIANT_HEIGHT_LangoAllen2010_publicrelease_HapMapCeuFreq.txt" "GIANT_BMI_Speliotes2010_publicrelease_HapMapCeuFreq.txt" "SCZ" "EUR.CD.gwas_info03_filtered.assoc" "EUR.UC.gwas_info03_filtered.assoc" "EUR.IBD.gwas_info03_filtered.assoc" )

for i in {1..21}
do
trait=${traits[$i-1]}

OUTDIR=/lustre/scratch114/teams/soranzo/users/vi1/ldsr/output_gwas_h3k27ac/$trait
INDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/LDSR/output_gwas/$trait
mkdir -p $OUTDIR
OUTANN=/lustre/scratch114/teams/soranzo/users/vi1/ldsr/annotations_ldsr_h3k27ac_formatted

python /lustre/scratch119/humgen/projects/uk10k/users/vi1/software/enrichment/ldsc/ldsc.py --h2 $INDIR/$trait.sumstats.gz --ref-ld-chr /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/LDSR/data/baseline/baseline.,$OUTANN/h3k27ac$j. --w-ld-chr /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/LDSR/data/weights/weights. --overlap-annot --frqfile-chr /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/LDSR/data/1000G_plinkfiles/1000G.mac5eur. --out $OUTDIR/$trait.A$j.withbaseline --print-coefficients

done

# bsub -J"ld1r[1-98]%10" -o ./logs/log.run.h3k27ac.%I -M9000 -R'rusage[mem=9000] select[mem>9000]' -- ./ldsc_run_h3k27ac.sh
