#!/bin/bash

declare -a traits
traits=("GIANT_HEIGHT_LangoAllen2010_publicrelease_HapMapCeuFreq.txt" "MAGIC_2hrGlucose_AdjustedForBMI.txt" "MAGIC_ln_HOMA-B.txt" "MPV.b37" "TC_ONE_Europeans.tbl" "GIANT_WHRadjBMI_Heid2010_publicrelease_HapMapCeuFreq.txt" "MAGIC_FastingGlucose.txt" "MAGIC_ln_HOMA-IR.txt" "TG_ONE_Europeans.tbl" "HDL_ONE_Europeans.tbl" "MAGIC_HbA1C.txt" "MCH.b37" "PCV.b37" "HGB.b37" "MAGIC_ln_FastingInsulin.txt" "MCHC.b37" "PLT.b37" "GIANT_BMI_Speliotes2010_publicrelease_HapMapCeuFreq.txt" "LDL_ONE_Europeans.tbl" "MAGIC_ln_fastingProinsulin.txt" "MCV.b37" "RBC.b37" "DIAGRAMv3.2012DEC17.txt" "SCZ" "EUR.CD.gwas_info03_filtered.assoc" "EUR.UC.gwas_info03_filtered.assoc" "EUR.IBD.gwas_info03_filtered.assoc")

i=${LSB_JOBINDEX}
trait=${traits[$i-1]}

OUTDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/LDSR/output_gwas/$trait
mkdir -p $OUTDIR

if [[ $i -eq 1 || $i -eq 6 || $i -eq 18 ]]; then
python /lustre/scratch119/humgen/projects/uk10k/users/vi1/software/enrichment/ldsc/munge_sumstats.py --sumstats /lustre/scratch119/humgen/projects/uk10k/users/vi1/GWASdatasets/Sept2016/$trait --merge-alleles /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/LDSR/data/w_hm3.snplist --out $OUTDIR/$trait --a1-inc
else
## create sumstats file
echo "SNP A1 A2 N Z P" > $OUTDIR/$trait.sumstats0

INPUTFILE=/lustre/scratch119/humgen/projects/uk10k/users/vi1/GWASdatasets/Sept2016/$trait.dir/$trait.hg19.clean.unified.formatting

if [[ $i -gt 22 ]]; then
sed 1d $INPUTFILE  | awk '{print $3, $4, $5, $10+$11 , $8, $9}' >> $OUTDIR/$trait.sumstats0
else
sed 1d $INPUTFILE  | awk '{print $3, $4, $5, $10 , $8, $9}' >> $OUTDIR/$trait.sumstats0
fi


python /lustre/scratch119/humgen/projects/uk10k/users/vi1/software/enrichment/ldsc/munge_sumstats.py --sumstats $OUTDIR/$trait.sumstats0 --merge-alleles /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/LDSR/data/w_hm3.snplist --out $OUTDIR/$trait

rm $OUTDIR/$trait.sumstats0

fi

##
python /lustre/scratch119/humgen/projects/uk10k/users/vi1/software/enrichment/ldsc/ldsc.py --h2 $OUTDIR/$trait.sumstats.gz --ref-ld-chr /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/LDSR/data/baseline/baseline. --w-ld-chr /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/LDSR/data/weights/weights. --overlap-annot --frqfile-chr /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/LDSR/data/1000G_plinkfiles/1000G.mac5eur. --out $OUTDIR/$trait.baseline --print-coefficients

# bsub -J"sumstats[1-27]" -o logs/log.sumstats.v3.%I -M5000 -R'rusage[mem=5000] select[mem>5000]' -- ./ldsc_prepare_sumstats.sh
