#!/bin/bash

OUTANN=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/LDSR/newann
mkdir -p $OUTANN

j=${LSB_JOBINDEX}
for chr in {1..22}
do
rm $OUTANN/null$j.$chr.annot
echo "CHR BP SNP CM A$j" | tr " " "\t" > $OUTANN/null$j.$chr.annot
ANNOT=/lustre/scratch119/humgen/projects/uk10k/users/vi1/FDR/bedfiles/annotations_ldsr/$chr/chr$chr.$j
paste -d " " <(zcat /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/LDSR/data/cell_type_groups/CNS.$chr.annot.gz | awk '{print $1, $2, $3, $4}' |sed 1d) <(sed 1d $ANNOT) | tr " " "\t" >> $OUTANN/null$j.$chr.annot
gzip $OUTANN/null$j.$chr.annot

bsub -M 1000 -R'rusage[mem=1000] select[mem>1000]' -o logs5/log.prep.s.chr$chr.$j -- python /lustre/scratch119/humgen/projects/uk10k/users/vi1/software/enrichment/ldsc/ldsc.py --l2 --bfile /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/LDSR/data/1000G_plinkfiles/1000G.mac5eur.$chr --ld-wind-cm 1 --annot $OUTANN/null$j.$chr.annot.gz --out $OUTANN/null$j.$chr --print-snps /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/LDSR/data/hapmap3_snps/hm.$chr.snp
echo $chr $j
done
#bsub -J"ldsr[1-1000]" -M 1000 -R'rusage[mem=1000] select[mem>1000]' -o logs5/log.prep.s.%I -- ./ldsc_prepare_annotation_files_null.sh

