#!/bin/bash

export PATH=/nfs/users/nfs_v/vi1/anaconda2/bin:$PATH

OUTANN=/lustre/scratch114/teams/soranzo/users/vi1/ldsr/annotations_ldsr_h3k4me3_formatted
mkdir -p $OUTANN
tmp=$(awk '{print $1}' /lustre/scratch114/teams/soranzo/users/vi1/ldsr/annotations_ldsr_h3k4me3/22/link_file.txt |sed 1d|tr "\n" " ")

j=${LSB_JOBINDEX}
for chr in {22..1}
do

echo "CHR BP SNP CM A$j" | tr " " "\t" > $OUTANN/h3k4me3$j.$chr.annot
ANNOT=/lustre/scratch114/teams/soranzo/users/vi1/ldsr/annotations_ldsr_h3k4me3/$chr/chr$chr.$j
paste -d " " <(zcat /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/LDSR/data/cell_type_groups/CNS.$chr.annot.gz | awk '{print $1, $2, $3, $4}' |sed 1d) <(sed 1d $ANNOT) | tr " " "\t" >> $OUTANN/h3k4me3$j.$chr.annot
gzip $OUTANN/h3k4me3$j.$chr.annot

python /lustre/scratch119/humgen/projects/uk10k/users/vi1/software/enrichment/ldsc/ldsc.py --l2 --bfile /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/LDSR/data/1000G_plinkfiles/1000G.mac5eur.$chr --ld-wind-cm 1 --annot $OUTANN/h3k4me3$j.$chr.annot.gz --out $OUTANN/h3k4me3$j.$chr --print-snps /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/LDSR/data/hapmap3_snps/hm.$chr.snp
echo $chr $j
done

# bsub -J"ldsr2[1-127]" -M 1000 -R'rusage[mem=1000] select[mem>1000]' -o /lustre/scratch114/teams/soranzo/users/vi1/ldsr/scripts/logs/log.prep.v2.h3k4me3.v4.%I -- ./prepare_annotation_files.v2.h3k4me3.NEW.sh
