#!/bin/bash

declare -a traits
traits=( "MPV.b37" "TC_ONE_Europeans.tbl" "MAGIC_FastingGlucose.txt" "TG_ONE_Europeans.tbl" "HDL_ONE_Europeans.tbl" "MAGIC_HbA1C.txt" "MCH.b37" "PCV.b37" "HGB.b37" "MCHC.b37" "PLT.b37" "LDL_ONE_Europeans.tbl" "MAGIC_ln_fastingProinsulin.txt" "MCV.b37" "RBC.b37" "GIANT_HEIGHT_LangoAllen2010_publicrelease_HapMapCeuFreq.txt" "GIANT_BMI_Speliotes2010_publicrelease_HapMapCeuFreq.txt" "SCZ" "EUR.CD.gwas_info03_filtered.assoc" "EUR.UC.gwas_info03_filtered.assoc" "EUR.IBD.gwas_info03_filtered.assoc" )

ph=${LSB_JOBINDEX}
trait=${traits[$ph-1]}
SNPS=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GREGOR/snpfiles_v2/$trait.inputsnps

OUTDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GREGOR/output_gwas_null/$trait/nullanns
mkdir -p $OUTDIR/in
mkdir -p $OUTDIR/out

echo -n > $OUTDIR/in/example.bed.file.index
for j in {1..1000}
do
BED=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GREGOR/bedfiles/null$j.bed
echo $BED >> $OUTDIR/in/example.bed.file.index
done

echo "INDEX_SNP_FILE = $SNPS" > $OUTDIR/in/example.config
echo "BED_FILE_INDEX = $OUTDIR/in/example.bed.file.index" >> $OUTDIR/in/example.config
echo "REF_DIR = /lustre/scratch119/humgen/projects/uk10k/users/vi1/software/enrichment/gregor/" >> $OUTDIR/in/example.config
echo "R2THRESHOLD = 0.8" >> $OUTDIR/in/example.config
echo "LDWINDOWSIZE = 1000000 ## must be less than 1MB; these two values define LD buddies" >> $OUTDIR/in/example.config
echo "OUT_DIR = $OUTDIR/out" >> $OUTDIR/in/example.config
echo "MIN_NEIGHBOR_NUM = 500 ## define the size of neighborhood" >> $OUTDIR/in/example.config
echo "BEDFILE_IS_SORTED = true  ## false, if the bed files are not sorted" >> $OUTDIR/in/example.config
echo "POPULATION = EUR  ## define the population, you can specify EUR, AFR, AMR or ASN" >> $OUTDIR/in/example.config
echo "TOPNBEDFILES = 1" >> $OUTDIR/in/example.config
echo "JOBNUMBER = 1" >> $OUTDIR/in/example.config
echo "MOSRUN = #" >> $OUTDIR/in/example.config

echo "PREPARATION DONE"

/software/hgi/pkglocal/perl5-5.20.1/bin/perl5.20.1 /lustre/scratch119/humgen/projects/uk10k/users/vi1/software/enrichment/gregor/GREGOR/script/GREGOR.pl --conf $OUTDIR/in/example.config

echo "CODE FINISHED"
mv $OUTDIR/out/StatisticSummaryFile.txt $OUTDIR/StatisticSummaryFile.txt
rm -r $OUTDIR/out

# bsub -q long -J"greg[1-21]" -M1000 -R'rusage[mem=1000] select[mem>1000]' -o logs_null/log.run.v3.%I -- ./gregor_run_null.sh
