#!/bin/bash
i=${LSB_JOBINDEX}

declare -a traits
traits=( "MPV.b37" "TC_ONE_Europeans.tbl" "MAGIC_FastingGlucose.txt" "TG_ONE_Europeans.tbl" "HDL_ONE_Europeans.tbl" "MAGIC_HbA1C.txt" "MCH.b37" "PCV.b37" "HGB.b37" "MCHC.b37" "PLT.b37" "LDL_ONE_Europeans.tbl" "MAGIC_ln_fastingProinsulin.txt" "MCV.b37" "RBC.b37" "GIANT_HEIGHT_LangoAllen2010_publicrelease_HapMapCeuFreq.txt" "GIANT_BMI_Speliotes2010_publicrelease_HapMapCeuFreq.txt" "SCZ" "EUR.CD.gwas_info03_filtered.assoc" "EUR.IBD.gwas_info03_filtered.assoc" "EUR.UC.gwas_info03_filtered.assoc" )
trait=${traits[$i-1]}

OUTDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GREGOR/snpfiles_v2/
mkdir -p $OUTDIR

if [[ $i -lt 18 ]]; then
awk '{print $1}' /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GOSHIFTER/output_gwas_v2/$trait/$trait.input  |sed 1d > $OUTDIR/$trait.inputsnps
else 
awk '{print $2":"$3}' /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GOSHIFTER/output_gwas_v2/$trait/$trait.input  |sed 1d > $OUTDIR/$trait.inputsnps
fi

# Extra for SCZ
# R
# a = read.table("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GREGOR/snpfiles_v2/SCZ.inputsnps", head=F)
# a[,1] = as.character(a[,1])
# ids = grep("chr",a[,1])
# mx = matrix(unlist(strsplit(as.character(a[ids,]),"_",fixed=T)),ncol=3,byrow=T)[,1:2]
# id = paste(mx[,1],":",mx[,2],sep="")
# a[ids,1] = id
# write.table(a,file="/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GREGOR/snpfiles_v2/SCZ.inputsnps", row.names=F, col.names=F, append=F, quote=F)

# bsub -q yesterday -J"gregor[1-21]" -M 100 -R"rusage[mem=100] select[mem>100]" -o logs_gwas/log.v3.input.%I -- ./gregor_prepare_input.sh





