#!/bin/bash

j=${LSB_JOBINDEX}
declare -a annotations
annotations=($(ls /lustre/scratch119/humgen/projects/uk10k/users/vi1/histone_modifications/newdata/H3K27ac/*narrowPeak*))
annotation=${annotations[$j-1]} 
declare -a traits
traits=( "MPV.b37" "TC_ONE_Europeans.tbl" "MAGIC_FastingGlucose.txt" "TG_ONE_Europeans.tbl" "HDL_ONE_Europeans.tbl" "MAGIC_HbA1C.txt" "MCH.b37" "PCV.b37" "HGB.b37" "MCHC.b37" "PLT.b37" "LDL_ONE_Europeans.tbl" "MAGIC_ln_fastingProinsulin.txt" "MCV.b37" "RBC.b37" "GIANT_HEIGHT_LangoAllen2010_publicrelease_HapMapCeuFreq.txt" "GIANT_BMI_Speliotes2010_publicrelease_HapMapCeuFreq.txt" "SCZ" "EUR.CD.gwas_info03_filtered.assoc" "EUR.UC.gwas_info03_filtered.assoc" "EUR.IBD.gwas_info03_filtered.assoc" )

for i in {1..21}
do
trait=${traits[$i-1]}
OUTDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GOSHIFTER/output_gwas_v2/$trait
mkdir -p $OUTDIR

/lustre/scratch119/humgen/projects/uk10k/users/vi1/software/enrichment/goshifter/goshifter-package-v0.2/goshifter.py --snpmap $OUTDIR/$trait.input --annotation $annotation --permute 10000 --ld /lustre/scratch118/humgen/resources/1000g/pairwise_ld/ --out $OUTDIR/$trait.goshifter.h3k27ac.ann$j
echo "Annotation" $j "Trait" $i
done

# bsub -J"goshifter2[1-98]" -M 1000 -R"rusage[mem=1000] select[mem>1000]" -o logs_gwas_null/log.run.h3k27ac.%I -- ./goshifter_run_h3k27ac.sh
