#!/bin/bash

i=${LSB_JOBINDEX}

GWASDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/GWASdatasets/Sept2016/
declare -a traits

#traits=("MPV.b37" "TC_ONE_Europeans.tbl" "MAGIC_FastingGlucose.txt" "TG_ONE_Europeans.tbl" "HDL_ONE_Europeans.tbl" "MAGIC_HbA1C.txt" "MCH.b37" "PCV.b37" "HGB.b37" "MCHC.b37" "PLT.b37" "LDL_ONE_Europeans.tbl" "MAGIC_ln_fastingProinsulin.txt" "MCV.b37" "RBC.b37")

traits=( "GIANT_HEIGHT_LangoAllen2010_publicrelease_HapMapCeuFreq.txt" "GIANT_WHRadjBMI_Heid2010_publicrelease_HapMapCeuFreq.txt" "GIANT_BMI_Speliotes2010_publicrelease_HapMapCeuFreq.txt"  "DIAGRAMv3.2012DEC17.txt" "cd-meta-uk10k" "ucmeta_gwas" "SCZ" "EUR.CD.gwas_info03_filtered.assoc" "EUR.IBD.gwas_info03_filtered.assoc" "EUR.UC.gwas_info03_filtered.assoc" )

trait=${traits[$i-1]}

OUTDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GOSHIFTER/output_gwas_v2/$trait
mkdir -p $OUTDIR
echo "SNP Chrom BP" | sed 's/ /\t/g' > $OUTDIR/$trait.input

INPUTFILE=$GWASDIR/$trait.dir/$trait.hg19.clean.unified.formatting 
GARFIELD_OUTDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/$trait
F1=${GARFIELD_OUTDIR}/garfield.prep.$trait.real.r001.out

## prune
awk '$3<0.00000001 {print $1,$2}' $F1| awk 'NR==FNR {a[$1":"$2]=$1":"$2;b[$1":"$2]=$0; next;} $1":"$2 in a {print $3, "chr"b[$1":"$2]}' - $INPUTFILE | sed 's/ /\t/g' >>$OUTDIR/$trait.input

echo "code finished"

# bsub -q normal -J"goshifter[8-10]" -M 1000 -R"rusage[mem=1000] select[mem>1000]" -o logs_gwas/log.v4.extra.traits.%I -- ./real_data_goshifter_prepare_input.v3.extra.traits.sh
