#!/bin/bash

n=$1

declare -a nms
nms=( "MAGIC_2hrGlucose_AdjustedForBMI.txt" "MAGIC_ln_HOMA-B.txt" "MPV.b37" "TC_ONE_Europeans.tbl" "MAGIC_FastingGlucose.txt" "MAGIC_ln_HOMA-IR.txt" "TG_ONE_Europeans.tbl" "HDL_ONE_Europeans.tbl" "MAGIC_HbA1C.txt" "MCH.b37" "PCV.b37" "HGB.b37" "MAGIC_ln_FastingInsulin.txt" "MCHC.b37" "PLT.b37" "LDL_ONE_Europeans.tbl" "MAGIC_ln_fastingProinsulin.txt" "MCV.b37" "RBC.b37" "GIANT_HEIGHT_LangoAllen2010_publicrelease_HapMapCeuFreq.txt" "GIANT_WHRadjBMI_Heid2010_publicrelease_HapMapCeuFreq.txt" "GIANT_BMI_Speliotes2010_publicrelease_HapMapCeuFreq.txt"  "DIAGRAMv3.2012DEC17.txt" "cd-meta-uk10k" "ucmeta_gwas" "ICBP_DBP_gwas" "ICBP_SBP_gwas" "SCZ" "EUR.CD.gwas_info03_filtered.assoc" "EUR.UC.gwas_info03_filtered.assoc" "EUR.IBD.gwas_info03_filtered.assoc" )

INPUTNAME=${nms[$[${LSB_JOBINDEX}-1]]}


DATADIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/garfield-data0
PVALDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/input/$INPUTNAME
if [[ ${LSB_JOBINDEX} -gt 23 ]];then
if [[ ${LSB_JOBINDEX} -lt 28 ]];then 
PVALDIR=$DATADIR/pval/$INPUTNAME
fi
fi

PRUNETAGSDIR=$DATADIR/tags/r001
CLUMPTAGSDIR=$DATADIR/tags/r08
#MAFTSSDDIR=$DATADIR/maftssd
MAFTSSDDIR=$DATADIR/features_r001
ANNOTDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/FDR/bedfiles/annotations
OUTDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/$INPUTNAME
mkdir -p $OUTDIR


ANNOTLINKFILE=$ANNOTDIR/link_file.txt
NANNOT=$((`cat $ANNOTLINKFILE | wc -l` - 1))
PTHRESH=1e-5,1e-8
PTHRESHTEST=1e-5,1e-8
BINNING="m1,n$n,t5,p1,k1"
echo "binning $BINNING"
F1=$OUTDIR/garfield.prep.$INPUTNAME.random.r001.bugfix.out


echo 'Prune and Clump'
echo -n > $F1
for CHR in `seq 1 22` 
do

echo 'CHR'$CHR

/lustre/scratch119/humgen/projects/uk10k/users/vi1/software_development/garfield_24March2017/extra/garfield-prep-chr-feat -ptags $PRUNETAGSDIR/chr$CHR -ctags $CLUMPTAGSDIR/chr$CHR -maftss $MAFTSSDDIR/chr$CHR -pval $PVALDIR/chr$CHR -ann $ANNOTDIR/chr$CHR -excl 0 -chr $CHR -o $F1

done

SUBSET="1-1000"
CONDITION=0

PTHRESH=1e-5,1e-8
F3=$OUTDIR/garfield.perm.$INPUTNAME.null.annotations.cap.R.feat.$BINNING.$PTHRESH.random.r001.bugfix.out

Rscript /lustre/scratch119/humgen/projects/uk10k/users/vi1/software_development/garfield_v2/extra/garfield-perm-feat.R -i $F1 -o $F3 -l $ANNOTLINKFILE -pt $PTHRESH -b $BINNING -s $SUBSET -c $CONDITION


#for n in 15 ;do bsub -q yesterday -M 80000 -R'rusage[mem=80000] select[mem>80000]' -J"perm2[1-31]" -o logsKBSPAN/log.perm2.random.r001.bugfix.binning.n$n.m1.%I  -- ./run_garfield.KBSPAN.nullannotations.random.r001.bugfix.binning1.sh $n
# done