#!/bin/bash

declare -a nms
nms=( "MAGIC_2hrGlucose_AdjustedForBMI.txt" "MAGIC_ln_HOMA-B.txt" "MPV.b37" "TC_ONE_Europeans.tbl" "MAGIC_FastingGlucose.txt" "MAGIC_ln_HOMA-IR.txt" "TG_ONE_Europeans.tbl" "HDL_ONE_Europeans.tbl" "MAGIC_HbA1C.txt" "MCH.b37" "PCV.b37" "HGB.b37" "MAGIC_ln_FastingInsulin.txt" "MCHC.b37" "PLT.b37" "LDL_ONE_Europeans.tbl" "MAGIC_ln_fastingProinsulin.txt" "MCV.b37" "RBC.b37" "GIANT_HEIGHT_LangoAllen2010_publicrelease_HapMapCeuFreq.txt" "GIANT_WHRadjBMI_Heid2010_publicrelease_HapMapCeuFreq.txt" "GIANT_BMI_Speliotes2010_publicrelease_HapMapCeuFreq.txt"  "DIAGRAMv3.2012DEC17.txt" "ICBP_DBP_gwas" "ICBP_SBP_gwas" "SCZ" "EUR.CD.gwas_info03_filtered.assoc" "EUR.UC.gwas_info03_filtered.assoc" "EUR.IBD.gwas_info03_filtered.assoc" )

INPUTNAME=${nms[$[${LSB_JOBINDEX}-1]]}


DATADIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/garfield-data0
PVALDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/input/$INPUTNAME
if [[ ${LSB_JOBINDEX} -gt 23 ]];then
if [[ ${LSB_JOBINDEX} -lt 26 ]];then 
PVALDIR=$DATADIR/pval/$INPUTNAME
fi
fi

PRUNETAGSDIR=$DATADIR/tags/r001
CLUMPTAGSDIR=$DATADIR/tags/r08
#MAFTSSDDIR=$DATADIR/maftssd
MAFTSSDDIR=$DATADIR/features_r001
#ANNOTDIR=/lustre/scratch113/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/shuffledann
#ANNOTDIR=/lustre/scratch113/projects/uk10k/users/vi1/FDR/bedfiles/annotations2
ANNOTDIR=$DATADIR/annotation
OUTDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/$INPUTNAME
mkdir -p $OUTDIR


ANNOTLINKFILE=$ANNOTDIR/link_file.txt
NANNOT=$((`cat $ANNOTLINKFILE | wc -l` - 1))
PTHRESH=1e-5,1e-8
PTHRESHTEST=1e-5,1e-8

F1=$OUTDIR/garfield.prep.$INPUTNAME.real.r001.out


SUBSET="42-166,292-590"
CONDITION=0

BINNING="m1,n15,t5,p1,k1"
PTHRESH=1e-1,1e-2,1e-3,1e-3,1e-4,1e-5,1e-6,1e-7,1e-8
F3=$OUTDIR/garfield.perm.$INPUTNAME.real.annotations.cap.R.feat.$BINNING.circus.real.r001.out
#Rscript /lustre/scratch113/projects/uk10k/users/vi1/software_development/garfield_v2/extra/garfield-perm-feat.R -i $F1 -o $F3 -l $ANNOTLINKFILE -pt $PTHRESH -b $BINNING -s $SUBSET -c $CONDITION

Padj=0.00025

PTHRESH=1e-8
CONDITION=1
SUBSET="42-166,292-590"
CONDITIONTHRESH=0.00025
Rscript /lustre/scratch119/humgen/projects/uk10k/users/vi1/software_development/garfield_v2/extra/garfield-perm-feat.R -i $F1 -o $F3 -pt $PTHRESH -b $BINNING -s $SUBSET -c $CONDITION -ct $CONDITIONTHRESH -l $ANNOTLINKFILE -padj $Padj

CONDITIONTHRESH=0.05
Rscript /lustre/scratch119/humgen/projects/uk10k/users/vi1/software_development/garfield_v2/extra/garfield-perm-feat.R -i $F1 -o $F3 -pt $PTHRESH -b $BINNING -s $SUBSET -c $CONDITION -ct $CONDITIONTHRESH -l $ANNOTLINKFILE -padj $Padj


cp $F3 $F3.1e-5

PTHRESH=1e-5
CONDITION=1
SUBSET="42-166,292-590"
CONDITIONTHRESH=0.00025
Rscript /lustre/scratch119/humgen/projects/uk10k/users/vi1/software_development/garfield_v2/extra/garfield-perm-feat.R -i $F1 -o $F3.1e-5 -pt $PTHRESH -b $BINNING -s $SUBSET -c $CONDITION -ct $CONDITIONTHRESH -l $ANNOTLINKFILE -padj $Padj

CONDITIONTHRESH=0.05
Rscript /lustre/scratch119/humgen/projects/uk10k/users/vi1/software_development/garfield_v2/extra/garfield-perm-feat.R -i $F1 -o $F3.1e-5 -pt $PTHRESH -b $BINNING -s $SUBSET -c $CONDITION -ct $CONDITIONTHRESH -l $ANNOTLINKFILE -padj $Padj

rm $F3.1e-5


# bsub -q normal -M 16000 -R'rusage[mem=16000] select[mem>16000]' -J"gar001p[1-29]" -o logsKBSPAN/log.real.condition.r001.%I  -- ./garfield_run_condition.sh
