# SF4 forest plots

library(ggplot2)
#threshrun=0.00025
threshrun=0.05
trait="LDL_ONE_Europeans.tbl"
trait="EUR.CD.gwas_info03_filtered.assoc"
trait="EUR.UC.gwas_info03_filtered.assoc"
trait="EUR.IBD.gwas_info03_filtered.assoc"

tbl2 = NULL

for (trait in c("DIAGRAMv3.2012DEC17.txt", "GIANT_BMI_Speliotes2010_publicrelease_HapMapCeuFreq.txt","GIANT_HEIGHT_LangoAllen2010_publicrelease_HapMapCeuFreq.txt", "GIANT_WHRadjBMI_Heid2010_publicrelease_HapMapCeuFreq.txt","HDL_ONE_Europeans.tbl","HGB.b37","ICBP_DBP_gwas","ICBP_SBP_gwas","LDL_ONE_Europeans.tbl","MAGIC_2hrGlucose_AdjustedForBMI.txt","MAGIC_FastingGlucose.txt","MAGIC_HbA1C.txt","MAGIC_ln_FastingInsulin.txt","MAGIC_ln_fastingProinsulin.txt","MAGIC_ln_HOMA-B.txt","MAGIC_ln_HOMA-IR.txt","MCH.b37","MCHC.b37","MCV.b37","MPV.b37","PCV.b37","PLT.b37","RBC.b37","TC_ONE_Europeans.tbl","TG_ONE_Europeans.tbl", "SCZ")){

a = read.table(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/",trait,"/garfield.perm.",trait,".real.annotations.cap.R.feat.m1,n15,t5,p1,k1.circus.real.r001.out",sep=""),head=T,comment.char="")
a = a[which(a[,2]==1e-08),]
if (length(which(a$Pvalue<0.000257))==0) {print(paste("FILES FOR TRAIT ", trait, " MISSING",sep=""))}
link = read.table("/lustre/scratch119/humgen/projects/uk10k/users/vi1/garfield-data0/annotation/link_file.txt",head=T)
a = cbind(a,link[1:nrow(a),])
a = a[which(a$Category=="Hotspots"),]
if (file.exists(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/",trait,"/garfield.perm.",trait,".real.annotations.cap.R.feat.m1,n15,t5,p1,k1.circus.real.r001.out.1e-8.",threshrun,".cond.indep",sep=""))){
ad = read.table(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/",trait,"/garfield.perm.",trait,".real.annotations.cap.R.feat.m1,n15,t5,p1,k1.circus.real.r001.out.1e-8.",threshrun,".cond.dep",sep=""),head=T,comment.char="")
ai = read.table(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/",trait,"/garfield.perm.",trait,".real.annotations.cap.R.feat.m1,n15,t5,p1,k1.circus.real.r001.out.1e-8.",threshrun,".cond.indep",sep=""),head=T,comment.char="")

tbl = rbind(ai,ad)
tbl$Status = c(rep("Independent",nrow(ai)),rep("Dependent",nrow(ad)))
tbl$Name = paste(a$Tissue[match(tbl[,2],a[,1])], " / ",a$Celltype[match(tbl[,2],a[,1])]," / ", a[match(tbl[,2],a[,1]),1] ,sep="" )
tbl$Name = factor(tbl$Name, levels = tbl$Name[nrow(tbl):1])

if (file.exists(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/",trait,"/garfield.perm.",trait,".real.annotations.cap.R.feat.m1,n15,t5,p1,k1.circus.real.r001.out.1e-8.",threshrun,".model.summary",sep=""))){
c = read.table(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/",trait,"/garfield.perm.",trait,".real.annotations.cap.R.feat.m1,n15,t5,p1,k1.circus.real.r001.out.1e-8.",threshrun,".model.summary",sep=""),head=T,comment.char="",sep="\t")
d = c[(nrow(c)-length(ai[,2])+1):nrow(c),]
tbl[1:length(ai[,2]),4:9] =  cbind(exp(d[,2]),d[,5],d[,2:3],d[,2]-1.96*d[,3],d[,2]+1.96*d[,3])
}
tbl$Uni="YES"
tbl$Uni[which(tbl$pvalold>0.00025)]="NO"
tbl$Trait=trait
tbl2 = rbind(tbl2,tbl)
}}




for (trait in c("EUR.CD.gwas_info03_filtered.assoc","EUR.UC.gwas_info03_filtered.assoc","EUR.IBD.gwas_info03_filtered.assoc")){

a = read.table(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/",trait,"/garfield.perm.",trait,".real.annotations.cap.R.feat.m1,n15,t5,p1,k1.circus.real.r001.out",sep=""),head=T,comment.char="")
a = a[which(a[,2]==1e-08),]
if (length(which(a$Pvalue<0.000257))==0) {print(paste("FILES FOR TRAIT ", trait, " MISSING",sep=""))}
link = read.table("/lustre/scratch119/humgen/projects/uk10k/users/vi1/garfield-data0/annotation/link_file.txt",head=T)
a = cbind(a,link[1:nrow(a),])
a = a[which(a$Category=="Hotspots"),]
if (file.exists(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/",trait,"/garfield.perm.",trait,".real.annotations.cap.R.feat.m1,n15,t5,p1,k1.circus.real.r001.out.",threshrun,".cond.indep",sep=""))){
ad = read.table(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/",trait,"/garfield.perm.",trait,".real.annotations.cap.R.feat.m1,n15,t5,p1,k1.circus.real.r001.out.",threshrun,".cond.dep",sep=""),head=T,comment.char="")
ai = read.table(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/",trait,"/garfield.perm.",trait,".real.annotations.cap.R.feat.m1,n15,t5,p1,k1.circus.real.r001.out.",threshrun,".cond.indep",sep=""),head=T,comment.char="")

tbl = rbind(ai,ad)
tbl$Status = c(rep("Independent",nrow(ai)),rep("Dependent",nrow(ad)))
tbl$Name = paste(a$Tissue[match(tbl[,2],a[,1])], " / ",a$Celltype[match(tbl[,2],a[,1])]," / ", a[match(tbl[,2],a[,1]),1] ,sep="" )
tbl$Name = factor(tbl$Name, levels = tbl$Name[nrow(tbl):1])

if (file.exists(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/",trait,"/garfield.perm.",trait,".real.annotations.cap.R.feat.m1,n15,t5,p1,k1.circus.real.r001.out.",threshrun,".model.summary",sep=""))){
c = read.table(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/",trait,"/garfield.perm.",trait,".real.annotations.cap.R.feat.m1,n15,t5,p1,k1.circus.real.r001.out.",threshrun,".model.summary",sep=""),head=T,comment.char="",sep="\t")
d = c[(nrow(c)-length(ai[,2])+1):nrow(c),]
tbl[1:length(ai[,2]),4:9] =  cbind(exp(d[,2]),d[,5],d[,2:3],d[,2]-1.96*d[,3],d[,2]+1.96*d[,3])
}
tbl$Uni="YES"
tbl$Uni[which(tbl$pvalold>0.00025)]="NO"
tbl$Trait=trait
tbl2 = rbind(tbl2,tbl)
}}


tbl2$Trait = as.factor(tbl2$Trait)
levels(tbl2$Trait) = c("CD","IBD","UC","HGT","HDL","HGB","LDL","MCH","MCV","MPV","PCV","PLT","RBC","SCZ","TG")
tbl2$Trait = factor(tbl2$Trait, levels=c("MCH","MCV","RBC","PCV","HGB","MPV","PLT","LDL","HDL","TG","CD","IBD","UC","HGT","SCZ"))

pdf(paste("../figures/forest",threshrun,".v2.r001.M1N15.all.pdf",sep=""),15,20)
p = ggplot(subset(tbl2,Uni %in% "YES" & Status %in% "Independent"),aes(Beta_c, Name, xmax=CI95_lower_c, xmin=CI95_upper_c)) +  geom_vline(xintercept = 0.0, linetype=2, alpha=0.75)+  geom_errorbarh(alpha=0.5, color="red", height = .4) + geom_point(size=5,colour="red") +theme_bw()+  geom_errorbarh(aes(Beta, Name, xmax=CI95_lower, xmin=CI95_upper),alpha=0.5, color="black", height = .4) + geom_point(aes(Beta, Name),size=5,colour="black")+ theme(text = element_text(size=16)) +xlab("log OR")+ylab("Tissue / Cell type")+facet_grid(Trait~., scales="free",space="free")+theme(text = element_text(size=30),strip.text.y = element_text(size = 30, angle = 0),strip.background = element_blank())
print(p)
dev.off()
system(paste("evince ../figures/forest",threshrun,".v2.r001.M1N15.all.pdf & ",sep=""))

