#!/bin/bash

declare -a nms
nms=( "MAGIC_2hrGlucose_AdjustedForBMI.txt" "MAGIC_ln_HOMA-B.txt" "MPV.b37" "TC_ONE_Europeans.tbl" "MAGIC_FastingGlucose.txt" "MAGIC_ln_HOMA-IR.txt" "TG_ONE_Europeans.tbl" "HDL_ONE_Europeans.tbl" "MAGIC_HbA1C.txt" "MCH.b37" "PCV.b37" "HGB.b37" "MAGIC_ln_FastingInsulin.txt" "MCHC.b37" "PLT.b37" "LDL_ONE_Europeans.tbl" "MAGIC_ln_fastingProinsulin.txt" "MCV.b37" "RBC.b37" "GIANT_HEIGHT_LangoAllen2010_publicrelease_HapMapCeuFreq.txt" "GIANT_WHRadjBMI_Heid2010_publicrelease_HapMapCeuFreq.txt" "GIANT_BMI_Speliotes2010_publicrelease_HapMapCeuFreq.txt"  "DIAGRAMv3.2012DEC17.txt" "cd-meta-uk10k" "ucmeta_gwas" "ICBP_DBP_gwas" "ICBP_SBP_gwas" "SCZ" "EUR.CD.gwas_info03_filtered.assoc" "EUR.IBD.gwas_info03_filtered.assoc" "EUR.UC.gwas_info03_filtered.assoc" )

INPUTNAME=${nms[$[${LSB_JOBINDEX}-1]]}
OUTDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/$INPUTNAME

F1=$OUTDIR/garfield.prep.$INPUTNAME.real.r001.h3k27ac.v2.narrowPeak.out
F0=$OUTDIR/garfield.Meff_Padj.$INPUTNAME.real.r001.h3k27ac.out

echo 'Calculate Effective Number of Annotations and Adjusted P-value'

Rscript /lustre/scratch119/humgen/projects/uk10k/users/vi1/software_development/garfield_24March2017/garfield-Meff-Padj.R -i $F1 -o $F0
NEA=$(head -1 $F0 |awk '{print $2}')
Padj=$(tail -1 $F0 |awk '{print $2}')
echo $NEA $Padj

# bsub -q normal -M 6000 -R'rusage[mem=6000] select[mem>6000]' -J"Meff[1-31]" -o logsKBSPAN/log.real.v2.Meff.r001.h3k27ac.%I  -- ./run_garfield.KBSPAN.real.annotations.r001.v2.Meff.h3k27ac.sh