#!/bin/bash

declare -a traits
traits=( "MPV.b37" "TC_ONE_Europeans.tbl" "MAGIC_FastingGlucose.txt" "TG_ONE_Europeans.tbl" "HDL_ONE_Europeans.tbl" "MAGIC_HbA1C.txt" "MCH.b37" "PCV.b37" "HGB.b37" "MCHC.b37" "PLT.b37" "LDL_ONE_Europeans.tbl" "MAGIC_ln_fastingProinsulin.txt" "MCV.b37" "RBC.b37" "GIANT_HEIGHT_LangoAllen2010_publicrelease_HapMapCeuFreq.txt" "GIANT_BMI_Speliotes2010_publicrelease_HapMapCeuFreq.txt" "SCZ" "EUR.CD.gwas_info03_filtered.assoc" "EUR.UC.gwas_info03_filtered.assoc" "EUR.IBD.gwas_info03_filtered.assoc" )

i=${LSB_JOBINDEX}
trait=${traits[$i-1]}

OUTDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/FGWAS/output_gwas_null/$trait
mkdir -p $OUTDIR

## prepare input
tmp=$(awk ' NR!=1 {print $1}' /lustre/scratch119/humgen/projects/uk10k/users/vi1/FDR/bedfiles/annotations/link_file.txt |tr "\n" " ")

if [[ $i -gt 17 ]] ;then
	echo "SNPID CHR POS F NCASE NCONTROL Z" $tmp > $OUTDIR/$trait.fgwas
else 
	echo "SNPID CHR POS F N Z" $tmp > $OUTDIR/$trait.fgwas
fi

for chr in {1..22}
	do
	INPUTFILE=/lustre/scratch119/humgen/projects/uk10k/users/vi1/GWASdatasets/Sept2016/$trait.dir/$trait.hg19.clean.unified.formatting
	ANNOT=/lustre/scratch119/humgen/projects/uk10k/users/vi1/FDR/bedfiles/annotations/chr$chr
	if [[ $i -gt 17 ]];then
		paste -d" " <(awk 'NR==FNR {a[$3]=$3;b[$3]=$0;next;} $1 in a {print b[$1]}' <(awk -v chr=$chr '$1==chr {print $3, $1, $2,$12, $10,$11,$8}' $INPUTFILE) $ANNOT) <(awk 'NR==FNR {a[$3]=$3;b[$3]=$0;next;} $1 in a {print $2}' <(awk -v chr=$chr '$1==chr {print $3, $1, $2,$12, $10,$11, $8}' $INPUTFILE) $ANNOT | sed 's/1/1 /g'| sed 's/0/0 /g') >> $OUTDIR/$trait.fgwas
	else
		paste -d" " <(awk 'NR==FNR {a[$3]=$3;b[$3]=$0;next;} $1 in a {print b[$1]}' <(awk -v chr=$chr '$1==chr {print $3, $1, $2,$11, $10,$8}' $INPUTFILE) $ANNOT) <(awk 'NR==FNR {a[$3]=$3;b[$3]=$0;next;} $1 in a {print $2}' <(awk -v chr=$chr '$1==chr {print $3, $1, $2,$11, $10,$8}' $INPUTFILE) $ANNOT | sed 's/1/1 /g'| sed 's/0/0 /g') >> $OUTDIR/$trait.fgwas
	fi
	echo $chr
done

gzip $OUTDIR/$trait.fgwas
INPUT=$OUTDIR/$trait.fgwas.gz


bsub -q normal -J"fgwas[1-1000]%100" -M 6000 -R'rusage[mem=6000] select[mem>6000]' -o logs4/real.log.null.$trait.%I -- ./fgwas_run_null.sub.sh $trait $i

if [[ $i -gt 17 ]]; then
	/lustre/scratch119/humgen/projects/uk10k/users/vi1/fgwas/fgwas-0.3.6/src/fgwas -cc -i $INPUT -o /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/FGWAS/output_gwas_null/$trait/${trait}_fgwas_null
else 
	/lustre/scratch119/humgen/projects/uk10k/users/vi1/fgwas/fgwas-0.3.6/src/fgwas -i $INPUT -o /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/FGWAS/output_gwas_null/$trait/${trait}_fgwas_null
fi

# bsub -q normal -J"fg[1-21]" -M 6000 -R'rusage[mem=6000] select[mem>6000]' -o logs4/real.log.null.array%I.0 -- ./fgwas_run_null.sh