#!/bin/bash

declare -a traits
traits=( "MPV.b37" "TC_ONE_Europeans.tbl" "MAGIC_FastingGlucose.txt" "TG_ONE_Europeans.tbl" "HDL_ONE_Europeans.tbl" "MAGIC_HbA1C.txt" "MCH.b37" "PCV.b37" "HGB.b37" "MCHC.b37" "PLT.b37" "LDL_ONE_Europeans.tbl" "MAGIC_ln_fastingProinsulin.txt" "MCV.b37" "RBC.b37" "GIANT_HEIGHT_LangoAllen2010_publicrelease_HapMapCeuFreq.txt" "GIANT_BMI_Speliotes2010_publicrelease_HapMapCeuFreq.txt" "SCZ" "EUR.CD.gwas_info03_filtered.assoc" "EUR.UC.gwas_info03_filtered.assoc" "EUR.IBD.gwas_info03_filtered.assoc" )

i=${LSB_JOBINDEX}
trait=${traits[$i-1]}

OUTDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/FGWAS/output_gwas_h3k27ac/$trait
INPUT=$OUTDIR/$trait.fgwas.gz

bsub -q normal -J"fgwas[1-98]" -M 6000 -R'rusage[mem=6000] select[mem>6000]' -o logs4/real.log.h3k27ac.$trait.%I -- ./fgwas_run_h3k27ac.sub.sh $trait $i

if [[ $i -gt 17 ]]; then
	/lustre/scratch119/humgen/projects/uk10k/users/vi1/fgwas/fgwas-0.3.6/src/fgwas -cc -i $INPUT -o /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/FGWAS/output_gwas_h3k27ac/$trait/${trait}_fgwas_null
else 
	/lustre/scratch119/humgen/projects/uk10k/users/vi1/fgwas/fgwas-0.3.6/src/fgwas -i $INPUT -o /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/FGWAS/output_gwas_h3k27ac/$trait/${trait}_fgwas_null
fi

# bsub -q normal -J"fg[1-21]" -M 6000 -R'rusage[mem=6000] select[mem>6000]' -o logs4/real.log.h3k27ac.array%I.0 -- ./fgwas_run_h3k27ac.sh
