#!/bin/bash

declare -a traits
traits=( "MPV.b37" "TC_ONE_Europeans.tbl" "MAGIC_FastingGlucose.txt" "TG_ONE_Europeans.tbl" "HDL_ONE_Europeans.tbl" "MAGIC_HbA1C.txt" "MCH.b37" "PCV.b37" "HGB.b37" "MCHC.b37" "PLT.b37" "LDL_ONE_Europeans.tbl" "MAGIC_ln_fastingProinsulin.txt" "MCV.b37" "RBC.b37" "GIANT_HEIGHT_LangoAllen2010_publicrelease_HapMapCeuFreq.txt" "GIANT_BMI_Speliotes2010_publicrelease_HapMapCeuFreq.txt" "SCZ" "EUR.CD.gwas_info03_filtered.assoc" "EUR.UC.gwas_info03_filtered.assoc" "EUR.IBD.gwas_info03_filtered.assoc" )

ph=${LSB_JOBINDEX}
trait=${traits[$ph-1]}

OUTDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/FGWAS/output_gwas_h3k4me3/$trait
mkdir -p $OUTDIR
tmp=$(awk ' NR!=1 {print $1}' /lustre/scratch119/humgen/projects/uk10k/users/vi1/histone_modifications/newdata/H3K4me3_garfield_narrowPeak/link_file.txt |tr "\n" " ")

if [[ $ph -gt 17 ]] ;then
	echo "SNPID CHR POS F NCASE NCONTROL Z" $tmp > $OUTDIR/$trait.fgwas
else 
	echo "SNPID CHR POS F N Z" $tmp > $OUTDIR/$trait.fgwas
fi

for chr in {1..22}
do
	INPUTFILE=/lustre/scratch119/humgen/projects/uk10k/users/vi1/GWASdatasets/Sept2016/$trait.dir/$trait.hg19.clean.unified.formatting
	ANNOT=/lustre/scratch119/humgen/projects/uk10k/users/vi1/histone_modifications/newdata/H3K4me3_garfield_narrowPeak/chr$chr
	if [[ $ph -gt 17 ]];then
		paste -d" " <(awk 'NR==FNR {a[$3]=$3;b[$3]=$0;next;} $1 in a {print b[$1]}' <(awk -v chr=$chr '$1==chr {print $3, $1, $2,$12, $10,$11,$8}' $INPUTFILE) $ANNOT) <(awk 'NR==FNR {a[$3]=$3;b[$3]=$0;next;} $1 in a {print $2}' <(awk -v chr=$chr '$1==chr {print $3, $1, $2,$12, $10,$11, $8}' $INPUTFILE) $ANNOT | sed 's/1/1 /g'| sed 's/0/0 /g') >> $OUTDIR/$trait.fgwas
	else
		paste -d" " <(awk 'NR==FNR {a[$3]=$3;b[$3]=$0;next;} $1 in a {print b[$1]}' <(awk -v chr=$chr '$1==chr {print $3, $1, $2,$11, $10,$8}' $INPUTFILE) $ANNOT) <(awk 'NR==FNR {a[$3]=$3;b[$3]=$0;next;} $1 in a {print $2}' <(awk -v chr=$chr '$1==chr {print $3, $1, $2,$11, $10,$8}' $INPUTFILE) $ANNOT | sed 's/1/1 /g'| sed 's/0/0 /g') >> $OUTDIR/$trait.fgwas
	fi
	echo $chr
done

gzip $OUTDIR/$trait.fgwas

###

OUTDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/FGWAS/output_gwas_h3k27ac/$trait
mkdir -p $OUTDIR
tmp=$(awk ' NR!=1 {print $1}' /lustre/scratch119/humgen/projects/uk10k/users/vi1/histone_modifications/newdata/H3K27ac_garfield_narrowPeak/link_file.txt |tr "\n" " ")

if [[ $ph -gt 17 ]] ;then
	echo "SNPID CHR POS F NCASE NCONTROL Z" $tmp > $OUTDIR/$trait.fgwas
else 
	echo "SNPID CHR POS F N Z" $tmp > $OUTDIR/$trait.fgwas
fi

for chr in {1..22}
do
	INPUTFILE=/lustre/scratch119/humgen/projects/uk10k/users/vi1/GWASdatasets/Sept2016/$trait.dir/$trait.hg19.clean.unified.formatting
	ANNOT=/lustre/scratch119/humgen/projects/uk10k/users/vi1/histone_modifications/newdata/H3K27ac_garfield_narrowPeak/chr$chr
	if [[ $ph -gt 17 ]];then
		paste -d" " <(awk 'NR==FNR {a[$3]=$3;b[$3]=$0;next;} $1 in a {print b[$1]}' <(awk -v chr=$chr '$1==chr {print $3, $1, $2,$12, $10,$11,$8}' $INPUTFILE) $ANNOT) <(awk 'NR==FNR {a[$3]=$3;b[$3]=$0;next;} $1 in a {print $2}' <(awk -v chr=$chr '$1==chr {print $3, $1, $2,$12, $10,$11, $8}' $INPUTFILE) $ANNOT | sed 's/1/1 /g'| sed 's/0/0 /g') >> $OUTDIR/$trait.fgwas
	else
		paste -d" " <(awk 'NR==FNR {a[$3]=$3;b[$3]=$0;next;} $1 in a {print b[$1]}' <(awk -v chr=$chr '$1==chr {print $3, $1, $2,$11, $10,$8}' $INPUTFILE) $ANNOT) <(awk 'NR==FNR {a[$3]=$3;b[$3]=$0;next;} $1 in a {print $2}' <(awk -v chr=$chr '$1==chr {print $3, $1, $2,$11, $10,$8}' $INPUTFILE) $ANNOT | sed 's/1/1 /g'| sed 's/0/0 /g') >> $OUTDIR/$trait.fgwas
	fi
	echo $chr
done

gzip $OUTDIR/$trait.fgwas


###

OUTDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/FGWAS/output_gwas/$trait
mkdir -p $OUTDIR
tmp=$(awk ' NR!=1 {print $1}' /lustre/scratch119/humgen/projects/uk10k/users/vi1/garfield-data/annotation/link_file.txt |tr "\n" " ")

if [[ $ph -gt 17 ]] ;then
	echo "SNPID CHR POS F NCASE NCONTROL Z" $tmp > $OUTDIR/$trait.fgwas
else 
	echo "SNPID CHR POS F N Z" $tmp > $OUTDIR/$trait.fgwas
fi

for chr in {1..22}
do
	INPUTFILE=/lustre/scratch119/humgen/projects/uk10k/users/vi1/GWASdatasets/Sept2016/$trait.dir/$trait.hg19.clean.unified.formatting
	ANNOT=/lustre/scratch119/humgen/projects/uk10k/users/vi1/garfield-data/annotation/chr$chr
	if [[ $ph -gt 17 ]];then
		paste -d" " <(awk 'NR==FNR {a[$3]=$3;b[$3]=$0;next;} $1 in a {print b[$1]}' <(awk -v chr=$chr '$1==chr {print $3, $1, $2,$12, $10,$11,$8}' $INPUTFILE) $ANNOT) <(awk 'NR==FNR {a[$3]=$3;b[$3]=$0;next;} $1 in a {print $2}' <(awk -v chr=$chr '$1==chr {print $3, $1, $2,$12, $10,$11, $8}' $INPUTFILE) $ANNOT | sed 's/1/1 /g'| sed 's/0/0 /g') >> $OUTDIR/$trait.fgwas
	else
		paste -d" " <(awk 'NR==FNR {a[$3]=$3;b[$3]=$0;next;} $1 in a {print b[$1]}' <(awk -v chr=$chr '$1==chr {print $3, $1, $2,$11, $10,$8}' $INPUTFILE) $ANNOT) <(awk 'NR==FNR {a[$3]=$3;b[$3]=$0;next;} $1 in a {print $2}' <(awk -v chr=$chr '$1==chr {print $3, $1, $2,$11, $10,$8}' $INPUTFILE) $ANNOT | sed 's/1/1 /g'| sed 's/0/0 /g') >> $OUTDIR/$trait.fgwas
	fi
	echo $chr
done

gzip $OUTDIR/$trait.fgwas



## bsub -J"fgwasPrep[1-21]" -q normal -M5000 -R'rusage[mem=5000] select[mem>5000]' -o logs3/log.prepare.%I -- ./fgwas_prepare_input.sh


