#!/bin/bash

declare -a nms
nms=( "MAGIC_2hrGlucose_AdjustedForBMI.txt" "MAGIC_ln_HOMA-B.txt" "MPV.b37" "TC_ONE_Europeans.tbl" "MAGIC_FastingGlucose.txt" "MAGIC_ln_HOMA-IR.txt" "TG_ONE_Europeans.tbl" "HDL_ONE_Europeans.tbl" "MAGIC_HbA1C.txt" "MCH.b37" "PCV.b37" "HGB.b37" "MAGIC_ln_FastingInsulin.txt" "MCHC.b37" "PLT.b37" "LDL_ONE_Europeans.tbl" "MAGIC_ln_fastingProinsulin.txt" "MCV.b37" "RBC.b37" "GIANT_HEIGHT_LangoAllen2010_publicrelease_HapMapCeuFreq.txt" "GIANT_WHRadjBMI_Heid2010_publicrelease_HapMapCeuFreq.txt" "GIANT_BMI_Speliotes2010_publicrelease_HapMapCeuFreq.txt"  "DIAGRAMv3.2012DEC17.txt" "ICBP_DBP_gwas" "ICBP_SBP_gwas" "SCZ" "EUR.CD.gwas_info03_filtered.assoc" "EUR.IBD.gwas_info03_filtered.assoc" "EUR.UC.gwas_info03_filtered.assoc" )

for ph in {1..29}
do
	trait=${nms[$[${ph}-1]]}
	OUTDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GPA/output_gwas_null_v2/$trait
	mkdir -p $OUTDIR
	bsub -J"ann[1-1000]%50" -M5000 -R'rusage[mem=5000] select[mem>5000]' -o logs4/log.$ph.ann.%I -- ./run_GPA.all.sub.sh $OUTDIR $ph $trait 
done



