# Rscript run_GPA.R /lustre/scratch113/projects/uk10k/users/vi1/enrichment_method_comparison/GPA/data/GIANT_HEIGHT_gwas.GPA.in.pval /lustre/scratch113/projects/uk10k/users/vi1/enrichment_method_comparison/GPA/data/GIANT_HEIGHT_gwas.GPA.in.ann.1 1 /lustre/scratch113/projects/uk10k/users/vi1/enrichment_method_comparison/GPA/data/GIANT_HEIGHT_gwas.GPA.1.out

args = commandArgs(trailingOnly=TRUE)
inputp = as.character(args[1])
inputann = as.character(args[2])
ann = as.numeric(args[3])
output = as.character(args[4])

library(GPA)
a = read.table(inputp,colClasses="numeric")
mat = read.table(inputann,colClasses="numeric")
m1 = GPA(a,maxIter=10000)
m2 = GPA(a,mat,maxIter=10000)
mm = aTest(m1,m2)
pval = mm$pvalue[[1]]
stats = mm$statistic[[1]]
q0=as.numeric(mm$q)[1]
q1=as.numeric(mm$q)[2]

mx = matrix(c(inputp,inputann,output,ann, stats,pval,q0,q1),nr=1)
colnames(mx) = c("inputp","inputann","output","ann","stats","pval","q0","q1")
write.table(mx, file=output, quote=F,append=F,row.names=F,col.names=T)
