#!/bin/bash

declare -a nms
nms=( "MAGIC_2hrGlucose_AdjustedForBMI.txt" "MAGIC_ln_HOMA-B.txt" "MPV.b37" "TC_ONE_Europeans.tbl" "MAGIC_FastingGlucose.txt" "MAGIC_ln_HOMA-IR.txt" "TG_ONE_Europeans.tbl" "HDL_ONE_Europeans.tbl" "MAGIC_HbA1C.txt" "MCH.b37" "PCV.b37" "HGB.b37" "MAGIC_ln_FastingInsulin.txt" "MCHC.b37" "PLT.b37" "LDL_ONE_Europeans.tbl" "MAGIC_ln_fastingProinsulin.txt" "MCV.b37" "RBC.b37" "GIANT_HEIGHT_LangoAllen2010_publicrelease_HapMapCeuFreq.txt" "GIANT_WHRadjBMI_Heid2010_publicrelease_HapMapCeuFreq.txt" "GIANT_BMI_Speliotes2010_publicrelease_HapMapCeuFreq.txt"  "DIAGRAMv3.2012DEC17.txt" "ICBP_DBP_gwas" "ICBP_SBP_gwas" "SCZ" "EUR.CD.gwas_info03_filtered.assoc" "EUR.IBD.gwas_info03_filtered.assoc" "EUR.UC.gwas_info03_filtered.assoc" )

trait=${nms[$[${LSB_JOBINDEX}-1]]}

DATADIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/garfield-data0
PVALDIR=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/input/$trait ## GARFIELD input format
if [[ ${LSB_JOBINDEX} -gt 23 ]];then
if [[ ${LSB_JOBINDEX} -lt 26 ]];then 
PVALDIR=$DATADIR/pval/$trait
fi
fi

dir=/lustre/scratch119/humgen/projects/uk10k/users/vi1/FDR/bedfiles/annotations
outdir=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GPA/data3

echo -n > $outdir/$trait.GPA.in
for chr in {1..22}
do
awk 'NR==FNR {a[$1]=$1;b[$1]=$2;next;} $1 in a {print $1,b[$1],$2}' $PVALDIR/chr$chr $dir/chr$chr >> $outdir/$trait.GPA.in
done

awk '{print $2}' $outdir/$trait.GPA.in > $outdir/$trait.GPA.in.pval

# bsub -J"gpa[1-29]" -o logs4/log.reformat.%I -M 1000 -R'rusage[mem=1000] select[mem>1000]' -- ./GPA_prepare_input.sh

