##### Figure 2b

r="r001"
for t in 1e-8 
do
for BINNING in "m5,n15,t5,p1,k1" "m5,n15,t1,p1,k1" "m5,n1,t5,p1,k1" "m1,n15,t5,p1,k1" "m1,n1,t5,p1,k1" "m5,n1,t1,p1,k1" "m1,n15,t1,p1,k1" "m1,n1,t1,p1,k1"
do
output=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/garfield.simulationsGWAS.summary.$t.$r.$BINNING.M1N15.txt2
echo "trait annotation or p" > $output
for tr in "MAGIC_2hrGlucose_AdjustedForBMI.txt" "MAGIC_ln_HOMA-B.txt" "MPV.b37" "TC_ONE_Europeans.tbl" "MAGIC_FastingGlucose.txt" "MAGIC_ln_HOMA-IR.txt" "TG_ONE_Europeans.tbl" "HDL_ONE_Europeans.tbl" "MAGIC_HbA1C.txt" "MCH.b37" "PCV.b37" "HGB.b37" "MAGIC_ln_FastingInsulin.txt" "MCHC.b37" "PLT.b37" "LDL_ONE_Europeans.tbl" "MAGIC_ln_fastingProinsulin.txt" "MCV.b37" "RBC.b37" "GIANT_HEIGHT_LangoAllen2010_publicrelease_HapMapCeuFreq.txt" "GIANT_WHRadjBMI_Heid2010_publicrelease_HapMapCeuFreq.txt" "GIANT_BMI_Speliotes2010_publicrelease_HapMapCeuFreq.txt"  "DIAGRAMv3.2012DEC17.txt" "ICBP_DBP_gwas" "ICBP_SBP_gwas" "SCZ" "EUR.CD.gwas_info03_filtered.assoc" "EUR.UC.gwas_info03_filtered.assoc" "EUR.IBD.gwas_info03_filtered.assoc" ; do awk -v tr=$tr -v t=$t '$2==t {print tr, $1, $3, $4}' /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/*/garfield.perm.$tr.real.annotations.cap.R.feat.$BINNING.circus.real.$r.timing.out >> $output; 
done
done
done

r="r001"
for t in 1e-5 
do
for BINNING in "m5,n15,t5,p1,k1" "m5,n15,t1,p1,k1" "m5,n1,t5,p1,k1" "m1,n15,t5,p1,k1" "m1,n1,t5,p1,k1" "m5,n1,t1,p1,k1" "m1,n15,t1,p1,k1" "m1,n1,t1,p1,k1"
do
output=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/garfield.simulationsGWAS.summary.$t.$r.$BINNING.M1N15.txt2
echo "trait annotation or p" > $output
for tr in "MAGIC_2hrGlucose_AdjustedForBMI.txt" "MAGIC_ln_HOMA-B.txt" "MPV.b37" "TC_ONE_Europeans.tbl" "MAGIC_FastingGlucose.txt" "MAGIC_ln_HOMA-IR.txt" "TG_ONE_Europeans.tbl" "HDL_ONE_Europeans.tbl" "MAGIC_HbA1C.txt" "MCH.b37" "PCV.b37" "HGB.b37" "MAGIC_ln_FastingInsulin.txt" "MCHC.b37" "PLT.b37" "LDL_ONE_Europeans.tbl" "MAGIC_ln_fastingProinsulin.txt" "MCV.b37" "RBC.b37" "GIANT_HEIGHT_LangoAllen2010_publicrelease_HapMapCeuFreq.txt" "GIANT_WHRadjBMI_Heid2010_publicrelease_HapMapCeuFreq.txt" "GIANT_BMI_Speliotes2010_publicrelease_HapMapCeuFreq.txt"  "DIAGRAMv3.2012DEC17.txt" "ICBP_DBP_gwas" "ICBP_SBP_gwas" "SCZ" "EUR.CD.gwas_info03_filtered.assoc" "EUR.UC.gwas_info03_filtered.assoc" "EUR.IBD.gwas_info03_filtered.assoc" ; do awk -v tr=$tr -v t=$t '$2==t {print tr, $1, $3, $4}' /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/*/garfield.perm.$tr.real.annotations.cap.R.feat.$BINNING.$t.circus.real.$r.timing.out >> $output; 
done
done
done



r="r001"
for t in 1e-8 1e-5
do
for BINNING in "m1,n15,t5,p1,k1"
do
output=/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/garfield.simulationsGWAS.summary.$t.$r.$BINNING.txt2
echo "trait annotation or p" > $output
for tr in "MAGIC_2hrGlucose_AdjustedForBMI.txt" "MAGIC_ln_HOMA-B.txt" "MPV.b37" "TC_ONE_Europeans.tbl" "MAGIC_FastingGlucose.txt" "MAGIC_ln_HOMA-IR.txt" "TG_ONE_Europeans.tbl" "HDL_ONE_Europeans.tbl" "MAGIC_HbA1C.txt" "MCH.b37" "PCV.b37" "HGB.b37" "MAGIC_ln_FastingInsulin.txt" "MCHC.b37" "PLT.b37" "LDL_ONE_Europeans.tbl" "MAGIC_ln_fastingProinsulin.txt" "MCV.b37" "RBC.b37" "GIANT_HEIGHT_LangoAllen2010_publicrelease_HapMapCeuFreq.txt" "GIANT_WHRadjBMI_Heid2010_publicrelease_HapMapCeuFreq.txt" "GIANT_BMI_Speliotes2010_publicrelease_HapMapCeuFreq.txt"  "DIAGRAMv3.2012DEC17.txt" "ICBP_DBP_gwas" "ICBP_SBP_gwas" "SCZ" "EUR.CD.gwas_info03_filtered.assoc" "EUR.UC.gwas_info03_filtered.assoc" "EUR.IBD.gwas_info03_filtered.assoc"; do awk -v tr=$tr -v t=$t '$2==t {print tr, $1, $3, $4}' /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/*/garfield.perm.$tr.real.annotations.cap.R.feat.$BINNING.circus.real.$r.out >> $output; 
done
done
done




#########

library(ggplot2)
library(wesanderson)
library(RColorBrewer)
library(reshape2)
pal <- wes_palette(15, name = "Darjeeling", type = "continuous")

threshold = 0.000257
r="r001"
t="1e-8"

tab = data.frame(Trait = c('DIAGRAMv3.2012DEC17.txt','EUR.CD.gwas_info03_filtered.assoc','EUR.IBD.gwas_info03_filtered.assoc','EUR.UC.gwas_info03_filtered.assoc','GIANT_BMI_Speliotes2010_publicrelease_HapMapCeuFreq.txt','GIANT_HEIGHT_LangoAllen2010_publicrelease_HapMapCeuFreq.txt','GIANT_WHRadjBMI_Heid2010_publicrelease_HapMapCeuFreq.txt','HDL_ONE_Europeans.tbl','HGB.b37','ICBP_DBP_gwas','ICBP_SBP_gwas','LDL_ONE_Europeans.tbl','MAGIC_2hrGlucose_AdjustedForBMI.txt','MAGIC_FastingGlucose.txt','MAGIC_HbA1C.txt','MAGIC_ln_FastingInsulin.txt','MAGIC_ln_fastingProinsulin.txt','MAGIC_ln_HOMA-B.txt','MAGIC_ln_HOMA-IR.txt','MCH.b37','MCHC.b37','MCV.b37','MPV.b37','PCV.b37','PLT.b37','RBC.b37','SCZ','TC_ONE_Europeans.tbl','TG_ONE_Europeans.tbl'), Trait2 = c("T2D","CD","IBD","UC","BMI","HGT","WHR","HDL","HGB","DBP","SBP","LDL","2hrG","FG","HbA1C","FI","FPI","HOMA-B","HOMA-IR","MCH","MCHC","MCV","MPV","PCV","PLT","RBC","SCZ","TC","TG"), Similarity = as.factor(c(2,6,6,6,1,1,1,4,5,3,3,4,2,2,2,2,2,2,2,5,5,5,5,5,5,5,7 ,4,4)))

read.data <- function(filename, threshold, features){
	a = read.table(filename,head=T,comment.char="")
	names(a) = c("disease","annotation","OR","pval")
	a = a[which(a$pval<threshold & a$OR>1),]
	return(a)
}

create_prop_frame <- function(a, b2, tab){
	c = as.data.frame(t(rbind(table(a$disease),table(b2$disease))))
	c = cbind(c,tab[match(rownames(c),tab[,1]),2:3])
	c$w = rep(10,29)
	c$h = rep(10,29)
	c$w[which(c$V1<10 & c$V2<10)][1:6] = c$w[which(c$V1<10 & c$V2<10)][1:6]+seq(-20,39,by=6)[1:6]+5
	c$h[which(c$V1<10 & c$V2<10)][1:6] = c$h[which(c$V1<10 & c$V2<10)][1:6]-seq(-20,59,length.out=10)[1:6]
	c$w[which(c$V1<10 & c$V2<10)][7:10] = c$w[which(c$V1<10 & c$V2<10)][7:10]+seq(-15,34,by=5)[7:10]-45
	c$h[which(c$V1<10 & c$V2<10)][7:10] = c$h[which(c$V1<10 & c$V2<10)][7:10]-seq(-40,39,length.out=10)[7:10]+10
	return(c)
}


a = read.data(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/garfield.simulationsGWAS.summary.",t,".",r,".m1,n1,t1,p1,k1.M1N15.txt2",sep=""),threshold,"m1,n1,t1")
b = read.data(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/garfield.simulationsGWAS.summary.",t,".",r,".m5,n15,t5,p1,k1.M1N15.txt2",sep=""),threshold,"m5,n15,t5")
d = read.data(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/garfield.simulationsGWAS.summary.",t,".",r,".m1,n15,t5,p1,k1.M1N15.txt2",sep=""),threshold,"m1,n15,t5")

binning1 = "m1,n15,t1"
b2 = read.data(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/garfield.simulationsGWAS.summary.",t,".",r,".",binning1,",p1,k1.M1N15.txt2",sep=""),threshold,binning1)
c = create_prop_frame(a,b2,tab)

pdf(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/figures/SF1b_newthresh.pdf",sep=""),14,7.5)
	p<-ggplot(c,aes(V2/424,V1/424,colour=Similarity))+ geom_abline(intercept = 0, slope = 1,colour="black",size=2,linetype=4) +geom_point(size=8) +theme_minimal()+geom_text(mapping = aes(x=(V2+w)/424,y=(V1+h)/424,label=Trait2))+ guides(colour=FALSE)+xlab(paste("Proportion of enriched annotations (N)",sep=""))+ylab(paste("Proportion of enriched annotations",sep=""))+theme(axis.text=element_text(size=24),axis.title=element_text(size=30),panel.grid.major = element_blank(), panel.grid.minor = element_blank())+scale_color_manual(values=pal[c(15,11,5,13, 1,3,8)])
	print(p)
dev.off()

# wilcox.test(c$V2/424,c$V1/424,paired=TRUE,  conf.int =TRUE) 

binning1 = "m1,n1,t5"
b2 = read.data(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/garfield.simulationsGWAS.summary.",t,".",r,".",binning1,",p1,k1.M1N15.txt2",sep=""),threshold,binning1)
c = create_prop_frame(a,b2,tab)

pdf(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/figures/SF1c_newthresh.pdf",sep=""),14,7.5)
	p<-ggplot(c,aes(V2/424,V1/424,colour=Similarity))+ geom_abline(intercept = 0, slope = 1,colour="black",size=2,linetype=4) +geom_point(size=8) +theme_minimal()+geom_text(mapping = aes(x=(V2+w)/424,y=(V1+h)/424,label=Trait2))+ guides(colour=FALSE)+xlab(paste("Proportion of enriched annotations (T)",sep=""))+ylab(paste("Proportion of enriched annotations",sep=""))+theme(axis.text=element_text(size=24),axis.title=element_text(size=30),panel.grid.major = element_blank(), panel.grid.minor = element_blank())+scale_color_manual(values=pal[c(15,11,5,13, 1,3,8)])
	print(p)
dev.off()

# wilcox.test(c$V2/424,c$V1/424,paired=TRUE,  conf.int =TRUE)

c = create_prop_frame(a,d,tab)
pdf(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/figures/F2b_newthresh.pdf",sep=""),14,7.5)
	p<-ggplot(c,aes(V2/424,V1/424,colour=Similarity))+ geom_abline(intercept = 0, slope = 1,colour="black",size=2,linetype=4) +geom_point(size=8) +theme_minimal()+geom_text(mapping = aes(x=(V2+w)/424,y=(V1+h)/424,label=Trait2))+ guides(colour=FALSE)+xlab(paste("Proportion of enriched annotations (N,T)",sep=""))+ylab(paste("Proportion of enriched annotations",sep=""))+theme(axis.text=element_text(size=24),axis.title=element_text(size=30),panel.grid.major = element_blank(), panel.grid.minor = element_blank())+scale_color_manual(values=pal[c(15,11,5,13, 1,3,8)])
	print(p)
dev.off()

# wilcox.test(c$V2/424,c$V1/424,paired=TRUE,  conf.int =TRUE)

############
tbl = NULL
for (t in c("1e-8","1e-5")){
	a = read.data(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/garfield.simulationsGWAS.summary.",t,".",r,".m1,n1,t1,p1,k1.M1N15.txt2",sep=""),threshold,"m1,n1,t1")
	for (binning1 in c("m1,n1,t5", "m1,n15,t1", "m1,n15,t5")){
		b2 = read.data(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/garfield.simulationsGWAS.summary.",t,".",r,".",binning1,",p1,k1.M1N15.txt2",sep=""),threshold,binning1)
		c = create_prop_frame(a,b2,tab)
		w = wilcox.test(c$V2/424,c$V1/424,paired=TRUE,  conf.int =TRUE)
		tbl  = rbind(tbl, c(r,t,binning1,w$estimate,w$p.value))
		print(c(r,t,binning1,w$estimate,w$p.value))
	}
}


              "r001"               "1e-8"           "m1,n1,t5" 
      (pseudo)median                      
"-0.102541331652665"  "0.001093939947288" 
                                                                     
                "r001"                 "1e-8"            "m1,n15,t1" 
        (pseudo)median                        
  "-0.343843935018107" "0.000143020073393161" 
                                                                     
                "r001"                 "1e-8"            "m1,n15,t5" 
        (pseudo)median                        
  "-0.464186346538198" "0.000143020073393161" 
                                                                     
                "r001"                 "1e-5"             "m1,n1,t5" 
        (pseudo)median                        
  "-0.099110419423884" "0.000320427050376264" 
                                                                     
                "r001"                 "1e-5"            "m1,n15,t1" 
        (pseudo)median                        
  "-0.481163796592599" "1.30588312467228e-05" 
                                                                     
                "r001"                 "1e-5"            "m1,n15,t5" 
        (pseudo)median                        
  "-0.643871819311606" "1.30588312467228e-05" 

tbl = as.data.frame(tbl)
names(tbl) = c("r2","Threshold","Correction","Median","Pvalue")
tbl$Correction = factor(tbl$Correction, levels=c("m1,n15,t5","m1,n15,t1","m1,n1,t5"))
levels(tbl$Correction) = c("N,T","N","T")
tbl$Median = -as.numeric(as.character(tbl$Median))
pdf(paste("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/figures/SF1d_newthresh.pdf",sep=""),14,5)
	p<-ggplot(tbl, aes(Correction, Median, fill=Threshold))+geom_bar(stat="identity", position="dodge")+ylab("Wilcoxon signed rank test proportion median excess") +xlab("Feature correction")+theme_minimal()+theme(axis.text=element_text(size=24),axis.title=element_text(size=30),panel.grid.major = element_blank(), panel.grid.minor = element_blank(),legend.text=element_text(size=rel(1.5)),legend.title=element_text(size=rel(1.6)))+scale_fill_manual(values=pal[c(1,3)])+ coord_flip()
	print(p)
dev.off()






###### FPR figures

a10 = read.table("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GOSHIFTER/output_gwas_null_v2/real.summary.full.txt2",head=T)
a20 = read.table("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GREGOR/output_gwas_null_v2/real.summary.full.txt2",head=T)
a30 = read.table("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/FGWAS/output_gwas_null_v2/FGWAS.all.summary.v2.txt.2",head=T,fill=T)
a30$p=1-pchisq(2*(a30[,3]-a30[,7]),1) # define fgwas p-value
a40 = read.table("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/real.summary.null.annotations.full.cap.r001.m1,n15,t5.txt",head=T, comment.char="")
a40[which(a40$Pvalue<0.05 & a40$OR<=1),4]=1
a50 = read.table("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/LDSR/output_gwas_null_v2/real.summary.full.withbaseline.txt2",head=T, comment.char="")
a60 = read.table("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GPA/output_gwas_null_v2/summary.txt.2",head=T, comment.char="")
a70 = read.table("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/real.summary.null.annotations.full.cap.naive.txt2",head=T, comment.char="")
a405 = read.table("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/real.summary.null.annotations.full.cap.1e-5.r001.m1,n15,t5.txt",head=T, comment.char="") 
a405[which(a405$Pvalue<0.05 & a405$OR<=1),4]=1

a20$EN=a20[,2]/a20[,3]
dat = data.frame( P = NULL, Trait=NULL)
dat = rbind(dat, cbind(unname(a10[,c(2,1)]),Stat=1,Method="GOSHIFTER"))
dat = rbind(dat, cbind(unname(a20[,c(4,5)]),Stat=1,Method="GREGOR"))
dat = rbind(dat, cbind(unname(a30[,c(8,1)]),Stat=as.numeric(a30$estimate>0),Method="FGWAS"))
dat = rbind(dat, cbind(unname(a40[,c(4,19)]),Stat=as.numeric(a40$OR>1),Method="GARFIELD"))
tmp=cbind(unname(a50[,c(10,11)]),Stat=as.numeric(a50[,10]>0),Method="LDSR")
tmp[,1] = 2*(1-pnorm(abs(tmp[,1])))
dat = rbind(dat, tmp)
dat = rbind(dat, cbind(unname(a60[,c(7,1)]),Stat=1,Method="GPA"))
dat = rbind(dat, cbind(unname(a70[,c(4,19)]),Stat=as.numeric(a70$OR>1),Method="Naive"))

names(dat) = c( "P", "Trait", "Stat" ,"Method")
dat$P[which(dat$P==0 & dat$Method=="GOSHIFTER")]=1e-4
dat$neglog10P = -log10(dat$P)

dat0 = data.frame( P = NULL, Trait=NULL)
dat0 = rbind(dat0, cbind(unname(a40[,c(4,19)]),Stat=as.numeric(a40$OR>1),Method="GARFIELD 1e-8"))
dat0 = rbind(dat0, cbind(unname(a405[,c(4,19)]),Stat=as.numeric(a405$OR>1),Method="GARFIELD 1e-5"))
names(dat0) = c( "P", "Trait", "Stat" ,"Method")
dat0$neglog10P = -log10(dat0$P)
dat00 = dat0
dat0=dat0[which(dat0$P<0.05 & dat0$Stat==1),]
dat0$Trait = as.factor(as.character(dat0$Trait))

levels(dat0$Trait) = c("CD-old","T2D","CD","IBD","UC","BMI","HGT","WHR","HDL","HGB","DBP","SBP","LDL","2hrG","FG","HbA1C","FI","FPI","HOMA-B","HOMA-IR","MCH","MCHC","MCV","MPV","PCV","PLT","RBC","SCZ","TC","TG","UC-old")
dat0$Trait = factor(dat0$Trait, levels=c("HGT","BMI","WHR","HDL","TG","LDL","TC","MCH","MCV","MCHC","RBC","HGB","PCV","PLT","MPV","FPI","FG","FI","2hrG","HbA1C","HOMA-B","HOMA-IR","T2D","DBP","SBP","SCZ","UC","CD","IBD", "CD-old","UC-old"))
dat0 = dat0[which(!(dat0$Trait %in% c("CD-old","UC-old"))),]
levels(dat0$Method)=c("1e-8","1e-5")
names(dat0)[4]="Threshold"

dat00$summary = as.numeric(dat00$P<0.05 & dat00$Stat==1)
levels(dat00$Trait) = c("CD-old","T2D","CD","IBD","UC","BMI","HGT","WHR","HDL","HGB","DBP","SBP","LDL","2hrG","FG","HbA1C","FI","FPI","HOMA-B","HOMA-IR","MCH","MCHC","MCV","MPV","PCV","PLT","RBC","SCZ","TC","TG","UC-old")
dat00$Trait = factor(dat00$Trait, levels=c("HGT","BMI","WHR","HDL","TG","LDL","TC","MCH","MCV","MCHC","RBC","HGB","PCV","PLT","MPV","FPI","FG","FI","2hrG","HbA1C","HOMA-B","HOMA-IR","T2D","DBP","SBP","SCZ","UC","CD","IBD", "CD-old","UC-old"))
dat00 = dat00[which(!(dat00$Trait %in% c("CD-old","UC-old"))),]
levels(dat00$Method)=c("1e-8","1e-5")
names(dat00)[4]="Threshold"

data_summary <- function(data, varname, groupnames){
  require(plyr)
  summary_func <- function(x, col){
    c(mean = mean(x[[col]], na.rm=TRUE),
      sd = sd(x[[col]], na.rm=TRUE), se = sd(x[[col]])/sqrt(length(x[[col]])) )
  }
  data_sum<-ddply(data, groupnames, .fun=summary_func,
                  varname)
  data_sum <- rename(data_sum, c("mean" = varname))
 return(data_sum)
}

df20 <- data_summary(dat00, varname="summary", 
                    groupnames=c("Trait", "Threshold"))
head(df20)

pdf("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/figures/SF1a_errorbar.pdf", 14,5)
ggplot(df20,aes(Trait, summary, fill=Threshold))+geom_bar(stat="identity",position="dodge",colour="black") + geom_errorbar(aes(ymin=summary-se, ymax=summary+se), width=.2, position=position_dodge(.9)) + theme_minimal()+ theme(strip.background = element_blank(),  strip.text.x = element_blank(),panel.grid.major = element_blank(), panel.grid.minor = element_blank(),axis.ticks.x = element_blank())+ylab("False positive rate")+xlab("Trait")+ theme(legend.justification=c(0,1), legend.position=c(0.0,1))+guides(colour=FALSE)+facet_grid(~Threshold)+geom_hline(yintercept = 0.05, size=1,linetype="dotdash")+ theme(axis.text.x = element_text(angle = 90, hjust =1, vjust = 0.5,size=12) )+  scale_y_continuous(limits=c(0, 1),expand=c(0,0),labels = function(x) x) +theme(legend.position="top")+theme(axis.text=element_text(size=24),axis.title=element_text(size=30),panel.grid.major = element_blank(), panel.grid.minor = element_blank(),legend.text=element_text(size=rel(1.5)),legend.title=element_text(size=rel(1.6)))+scale_fill_manual(values=pal[c(1,3)]) #+ coord_flip()
dev.off()
system("evince /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/figures/SF1a_errorbar.pdf &")

dat2=dat[which(dat$P<0.05),]
dat2=dat2[which(dat2$P<0.05 & dat2$Stat==1),]
dat2 = dat2[which(dat2$Trait %in% levels(dat2$Trait)[c(2:6,8:23)]),]
dat2$Trait = as.factor(as.character(dat2$Trait))
levels(dat2$Trait) = c("CD","IBD","UC","BMI","HGT","HDL","HGB","LDL","FG","HbA1C","FPI","MCH","MCHC","MCV","MPV","PCV","PLT","RBC","SCZ","TC","TG")
dat2$Trait = factor(dat2$Trait, levels=c("HGT","BMI","HDL","TG","LDL","TC","MCH","MCV","MCHC","RBC","HGB","PCV","PLT","MPV","UC","CD","IBD","FPI","FG","HbA1C","SCZ"))
dat2$Method = factor(dat2$Method,levels=levels(dat2$Method)[c(7,4,2,5,3,1,6)])
aggregate(dat$P<0.05 & dat$Stat==1,list(dat$Trait, dat$Method), sd)

dat$summary = as.numeric(dat$P<0.05 & dat$Stat==1)

data_summary <- function(data, varname, groupnames){
  require(plyr)
  summary_func <- function(x, col){
    c(mean = mean(x[[col]], na.rm=TRUE),
      sd = sd(x[[col]], na.rm=TRUE), se = sd(x[[col]])/sqrt(length(x[[col]])) )
  }
  data_sum<-ddply(data, groupnames, .fun=summary_func,
                  varname)
  data_sum <- rename(data_sum, c("mean" = varname))
 return(data_sum)
}

df2 <- data_summary(dat, varname="summary", 
                    groupnames=c("Trait", "Method"))
head(df2)
library(ggplot2)

df2 = df2[which(df2$Trait %in% levels(df2$Trait)[c(2:6,8:23)]),]
df2$Trait = as.factor(as.character(df2$Trait))
levels(df2$Trait) = c("CD","IBD","UC","BMI","HGT","HDL","HGB","LDL","FG","HbA1C","FPI","MCH","MCHC","MCV","MPV","PCV","PLT","RBC","SCZ","TC","TG")
df2$Trait = factor(df2$Trait, levels=c("HGT","BMI","HDL","TG","LDL","TC","MCH","MCV","MCHC","RBC","HGB","PCV","PLT","MPV","UC","CD","IBD","FPI","FG","HbA1C","SCZ"))
df2$Method = factor(df2$Method,levels=levels(df2$Method)[c(7,4,2,5,3,1,6)])
df2$se = df2$sd/sqrt(1000)

pdf("/lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/figures/F2a_errorbar.pdf", 14,5)
ggplot(df2,aes(Trait, summary, fill=Method))+geom_bar(stat="identity",position="dodge",colour="black") +  geom_errorbar(aes(ymin=summary-se, ymax=summary+se), width=.2,
                 position=position_dodge(.9)) + theme_minimal()+ theme(strip.background = element_blank(),  strip.text.x = element_blank(),panel.grid.major = element_blank(), panel.grid.minor = element_blank(),axis.ticks.x = element_blank(),axis.text=element_text(size=13), axis.title=element_text(size=14))+ylab("False positive rate")+xlab("Trait / Method")+scale_fill_manual(values=c("grey","red","orange","lightgoldenrod2","lightgreen","steelblue3","skyblue"))+ theme(legend.justification=c(0,1), legend.position=c(0.0,1))+guides(colour=FALSE)+facet_grid(~Method)+geom_hline(yintercept = 0.05, size=1,linetype="dotdash")+ theme(axis.text.x = element_text(angle = 90, hjust =1, vjust = 0.5,size=8) )+  scale_y_continuous(limits=c(0, 1),expand=c(0,0),labels = function(x) x) +theme(legend.position="top")+theme(axis.text=element_text(size=24),axis.title=element_text(size=30),panel.grid.major = element_blank(), panel.grid.minor = element_blank(),legend.text=element_text(size=rel(1.5)),legend.title=element_text(size=rel(1.6)))
dev.off()
system("evince /lustre/scratch119/humgen/projects/uk10k/users/vi1/enrichment_method_comparison/GARFIELD/output_v2/figures/F2a_errorbar.pdf &")

t1 = aggregate(dat2$Stat, list(dat2$Method, dat2$Trait), length)
t2 = aggregate(t1$x, list(t1$Group.1),mean)
t2$y = t2$x/1000
#    Group.1         x          y
#1     Naive 136.16667 0.13616667
#2  GARFIELD  32.11111 0.03211111
#3    GREGOR  90.05556 0.09005556
#4      LDSR  26.50000 0.02650000
#5     FGWAS  21.50000 0.02150000
#6 GOSHIFTER  32.33333 0.03233333
#7       GPA 278.05556 0.27805556

#t2
#    Group.1         x          y
#1     Naive 153.28571 0.15328571
#2  GARFIELD  28.85714 0.02885714
#3    GREGOR  85.42857 0.08542857
#4      LDSR  25.52381 0.02552381
#5     FGWAS  21.38095 0.02138095
#6 GOSHIFTER  32.76190 0.03276190
#7       GPA 327.61905 0.32761905

